#!/bin/bash

# Determine command type
cmd_type="ui"
if [ $# -gt 0 ]; then
    case $1 in
    --cli-only)
        cmd_type="cli-only";;
    --arm)
        cmd_type="arm";;
    --aarch64)
        cmd_type="aarch64";;
    --help)
        ;&
    *)
        cmd_type="usage";;
    esac
fi

# Determine Linux Distro and Version
. /etc/os-release

if [ $ID == "ubuntu" ]; then
    linux_ver=${VERSION_ID:0:2}
elif [[ $ID == "rhel" || $ID == "centos" ]]; then
    linux_ver=${VERSION_ID:0:1}
fi

case $cmd_type in
    cli-only)
        # CLI Only Uninstall
        case $ID in
            ubuntu)
                sudo apt-get -y remove globalprotect
                ;;
            rhel)
                ;&
            fedora)
                ;&
            rocky)
                ;&
            centos)
                sudo yum -y remove GlobalProtect_rpm
                ;;
            *)
                echo "Error: Unsupported Linux Distro: $ID"
                exit
                ;;
        esac
        ;;

    arm)
        # ARM Uninstall
        case $ID in
            ubuntu)
                sudo apt-get -y remove globalprotect
                ;;
            rhel)
                ;&
            fedora)
                ;&
            rocky)
                ;&
            centos)
                sudo yum -y remove GlobalProtect_rpm_arm
                ;;
            *)
                echo "Error: Unsupported Linux Distro: $ID"
                exit
                ;;
        esac
        ;;
		
    aarch64)
        # AARCH64 Uninstall
        case $ID in
            ubuntu)
                sudo apt-get -y remove globalprotect
                ;;
            rhel)
                ;&
            fedora)
                ;&
            rocky)
                ;&
            centos)
                sudo yum -y remove GlobalProtect_rpm_aarch64
                ;;
            *)
                echo "Error: Unsupported Linux Distro: $ID"
                exit
                ;;
        esac
        ;;

    ui)
        # UI Uninstall
        case $ID in
            ubuntu)
                sudo apt-get -y remove globalprotect
                ;;
            fedora)
                sudo rpm -ev GlobalProtect_UI_rpm
                ;;
            rhel)
                ;&
            rocky)
                ;&
            centos)
                sudo yum -y remove GlobalProtect_UI_rpm
                ;;
            *)
                echo "Error: Unsupported Linux Distro: $ID"
                exit
                ;;
        esac
        ;;
    usage)
        ;&
    *)
        echo "Usage: $ ./gp_uninstall [--cli-only | --arm | --help]"
        echo "  --cli-only: CLI Only"
        echo "  --arm:      ARM (32 bit)"
        echo "  --aarch64:  ARM64/aarch64 (64 bit)"
        echo "  default:    UI"
        ;;
esac
